% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{oce-class}
\alias{oce-class}
\title{Base Class for oce Objects}
\description{
This is mainly used within oce to create sub-classes, although
users can use \code{new("oce")} to create a blank \code{oce}
object, if desired.
}
\section{Slots}{

\describe{
\item{\code{metadata}}{A list containing information about the data. The 
contents vary across sub-classes, e.g. an \code{\link{adp-class}}
object has information about beam patterns, which obviously would
not make sense for a \code{\link{ctd-class}} object. In addition,
all classes have items named \code{units} and \code{flags}, used
to store information on the units of the data, and the data quality.}

\item{\code{data}}{A list containing the data.}

\item{\code{processingLog}}{A list containing time-stamped processing steps,
typically stored in the object by oce functions.}
}}
\examples{
str(new("oce"))

}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{odf-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}
}

