% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{class}
\name{section-class}
\alias{section-class}
\title{Class to Store Hydrographic Section Data}
\description{
Class to store hydrographic section data, with standard slots \code{metadata},
\code{data} and \code{processingLog}.

A \code{\link{list}} of stations is retrieved by \code{s[["station"]]}.
Individual stations are retrieved by providing a station number as a second
argument in the index, e.g.  the first station is \code{s[["station", 1]]}
(which is a \code{\link{ctd-class}} object).
        
Aggregated values of the quantities measured at each level of the CTD
profiles contained within the section may be accessed as e.g.
\code{section[["salinity"]]}.  This works for any quantity whose name is
present in the constituent profiles.   

Since it is often useful to pair such quantities with locations,
\code{section[["longitude"]]} and \code{section[["latitude"]]} return vectors
with values repeated for each level in each CTD (see the \code{pairs()} call in
                                                 the example section).  If just
one latitude or longitude is desired per station, e.g.
\code{section[["latitude", "byStation"]]} may be used.  Station-by-station
values of dynamic height are provided by e.g.
\code{section[["dynamic height"]]}.

The depths of all data are obtained from e.g.  \code{section[["depth"]]}, and
the distances along the transect, measured from the first station, are obtained
from e.g.  \code{section[["distance"]]}.
}
\examples{
library(oce)
data(section)
plot(section[['station', 1]])
pairs(cbind(z=-section[["pressure"]],T=section[["temperature"]],S=section[["salinity"]]))
## T profiles for first few stations in section, at common scale
par(mfrow=c(3,3))
Tlim <- range(section[["temperature"]])
ylim <- rev(range(section[["pressure"]]))
for (stn in section[["station",1:9]])
    plotProfile(stn, xtype='temperature', ylim=ylim, Tlim=Tlim)

}
\author{
Dan Kelley
}
\seealso{
Sections can be read with \code{\link{read.section}} or created with
\code{\link{read.section}} or created from CTD objects by using
\code{\link{as.section}} or by adding a ctd station to an existing section with
\code{\link{sectionAddStation}}.

Sections may be sorted with \code{\link{sectionSort}}, subsetted with
\code{\link{subset,section-method}}, smoothed with \code{\link{sectionSmooth}}, and
gridded with \code{\link{sectionGrid}}.  Gridded sections may be plotted with
\code{\link{plot,section-method}}.  
    
Statistical summaries are provided by \code{\link{summary,section-method}}, while
overviews are provided by \code{show}.  
    
The sample dataset \code{\link{section}} contains data along WOCE line A03.

Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}

