% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidem.R
\docType{methods}
\name{summary,tidem-method}
\alias{summary,tidem-method}
\title{Summarize a Tidem Object}
\usage{
\S4method{summary}{tidem}(object, p, constituent, ...)
}
\arguments{
\item{object}{an object of class \code{"tidem"}, usually, a result of a call
to \code{tidem}.}

\item{p}{optional value of the maximum p value for the display of an
individual coefficient.  If not given, all coefficients are shown.}

\item{constituent}{optional name of constituent on which to focus.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{NULL}
}
\description{
By default, all fitted constituents are plotted, but it is quite useful to
set e.g. p=0.05 To see just those constituents that are significant at the 5
percent level.
Note that the p values are estimated as the average of the p values for the
sine and cosine components at a given frequency.
}
\examples{
\dontrun{
library(oce)
data(sealevel)
tide <- tidem(sealevel)
summary(tide)
}

}
\seealso{
Other things related to \code{tidem} data: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{predict.tidem}}, \code{\link{tidedata}},
  \code{\link{tidem-class}}, \code{\link{tidemAstron}},
  \code{\link{tidemVuf}}, \code{\link{tidem}}
}
\author{
Dan Kelley
}
