% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\name{findBottom}
\alias{findBottom}
\title{Find the Ocean Bottom in an Echosounder Object}
\usage{
findBottom(x, ignore = 5, clean = despike)
}
\arguments{
\item{x}{an object of class \code{echosounder}}

\item{ignore}{number of metres of data to ignore, near the surface}

\item{clean}{a function to clean the inferred depth of spikes}
}
\value{
A list with elements: the \code{time} of a ping, the \code{depth} of
the inferred depth in metres, and the \code{index} of the inferred bottom
location, referenced to the object's \code{depth} vector.
}
\description{
Finds the depth in a Biosonics echosounder file, by finding the strongest
reflector and smoothing its trace.
}
\seealso{
The documentation for \code{\link{echosounder-class}} explains the
structure of \code{echosounder} objects, and also outlines the other
functions dealing with them.

Other things related to \code{echosounder} data: \code{\link{[[,echosounder-method}},
  \code{\link{[[<-,echosounder-method}},
  \code{\link{as.echosounder}},
  \code{\link{echosounder-class}},
  \code{\link{echosounder}},
  \code{\link{plot,echosounder-method}},
  \code{\link{read.echosounder}},
  \code{\link{subset,echosounder-method}},
  \code{\link{summary,echosounder-method}}
}
\author{
Dan Kelley
}
\concept{things related to \code{echosounder} data}
