% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{sectionGrid}
\alias{sectionGrid}
\title{Grid a Section}
\usage{
sectionGrid(section, p, method = "approx",
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{section}{A \code{section} object containing the section to be gridded.}

\item{p}{Optional indication of the pressure levels to which interpolation
should be done.  If this is not supplied, the pressure levels will be
calculated based on the typical spacing in the ctd profiles stored within
\code{section}.  If \code{p="levitus"}, then pressures will be set to be those
of the Levitus atlas, given by \code{\link{standardDepths}}, trimmed to the
maximum pressure in \code{section}.  If \code{p} is a single numerical value,
it is taken as the number of subdivisions to use in a call to \code{\link{seq}}
that has range from 0 to the maximum pressure in \code{section}.  Finally, if a
vector numerical values is provided, then it is used as is.}

\item{method}{The method to use to decimate data within the stations; see
\code{\link{ctdDecimate}}, which is used for the decimation.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}

\item{...}{Optional arguments to be supplied to \code{\link{ctdDecimate}},
e.g. \code{rule} controls extrapolation beyond the observed pressure range,
in the case where \code{method} equals \code{"approx"}.}
}
\value{
An object of \code{\link{section-class}} that contains stations whose
pressure values match identically.
}
\description{
Grid a section, by interpolating to fixed pressure levels.  The
\code{"approx"}, \code{"boxcar"} and \code{"lm"} methods are described in the
documentation for \code{\link{ctdDecimate}}, which is used to do this
processing.  The default \code{"approx"} method is best for bottle data, the
\code{"boxcar"} is best for ctd data, and the \code{"lm"} method is probably
too slow to recommend for exploratory work, in which it is common to do trials
with a variety of \code{"p"} values.
}
\section{A note about flags}{

Data-quality flags contained within the original object are ignored by this
function, and the returned value contains no such flags.  This is because such
flags represent an assessment of the original data, not of quantities derived
from those data.  This function produces a warning to this effect. The
recommended practice is to use \code{\link{handleFlags}} or some other means to
deal with flags before calling the present function.
}

\examples{
# Gulf Stream
library(oce)
data(section)
GS <- subset(section, 109<=stationId&stationId<=129)
GSg <- sectionGrid(GS, p=seq(0, 5000, 100))
plot(GSg, map.xlim=c(-80,-60))

}
\seealso{
Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{initializeFlagScheme,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionSmooth}}, \code{\link{sectionSort}},
  \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}
\author{
Dan Kelley
}
\concept{things related to \code{section} data}
