% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{byteToBinary}
\alias{byteToBinary}
\title{Format bytes as binary [defunct]}
\usage{
byteToBinary(x, endian = "big")
}
\arguments{
\item{x}{an integer to be interpreted as a byte.}

\item{endian}{character string indicating the endian-ness ("big" or
"little"). \strong{This argument will be removed in the upcoming CRAN
release.}}
}
\value{
A character string representing the bit strings for the elements of
\code{x}, in order of significance for the \code{endian="big"} case.
(The nibbles, or 4-bit sequences, are interchanged in the now-deprecated
\code{"little"} case.)
See \dQuote{Examples} for how this relates to the output from
\link{rawToBits}.
}
\description{
\strong{WARNING:} The \code{endian} argument will soon be removed
from this function; see \link{oce-defunct}.
This is because the actions for \code{endian="little"} made
no sense in practical work. The default value for \code{endian}
was changed to \code{"big"} on 2017 May 6.
}
\examples{
library(oce)
## Note comparison with rawToBits():
a <- as.raw(0x0a)
byteToBinary(a, "big")        # "00001010"
as.integer(rev(rawToBits(a))) # 0 0 0 0 1 0 1 0
}
\author{
Dan Kelley
}
