% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\docType{methods}
\name{subset,cm-method}
\alias{subset,cm-method}
\title{Subset a CM Object}
\usage{
\S4method{subset}{cm}(x, subset, ...)
}
\arguments{
\item{x}{a \code{cm} object, i.e. inheriting from \code{\link{cm-class}}.}

\item{subset}{a condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{...}{ignored.}
}
\value{
A new \code{cm} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
}
\examples{
library(oce)
data(cm)
plot(cm)
plot(subset(cm, time < mean(range(cm[['time']]))))

}
\seealso{
Other things related to cm data: \code{\link{[[,cm-method}},
  \code{\link{[[<-,cm-method}}, \code{\link{as.cm}},
  \code{\link{cm-class}}, \code{\link{cm}},
  \code{\link{plot,cm-method}}, \code{\link{read.cm}},
  \code{\link{rotateAboutZ}},
  \code{\link{summary,cm-method}}

Other functions that subset oce objects: \code{\link{subset,adp-method}},
  \code{\link{subset,adv-method}},
  \code{\link{subset,amsr-method}},
  \code{\link{subset,argo-method}},
  \code{\link{subset,coastline-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{subset,echosounder-method}},
  \code{\link{subset,lobo-method}},
  \code{\link{subset,met-method}},
  \code{\link{subset,oce-method}},
  \code{\link{subset,odf-method}},
  \code{\link{subset,rsk-method}},
  \code{\link{subset,sealevel-method}},
  \code{\link{subset,section-method}},
  \code{\link{subset,topo-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to cm data}
