% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binAverage}
\alias{binAverage}
\title{Bin-average a vector y, based on x values}
\usage{
binAverage(x, y, xmin, xmax, xinc)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{y}{a vector of numerical values.}

\item{xmin}{x value at the lower limit of first bin; the minimum \code{x}
will be used if this is not provided.}

\item{xmax}{x value at the upper limit of last bin; the maximum \code{x}
will be used if this is not provided.}

\item{xinc}{width of bins, in terms of x value; 1/10th of \code{xmax-xmin}
will be used if this is not provided.}
}
\value{
A list with two elements: \code{x}, the mid-points of the bins, and
\code{y}, the average \code{y} value in the bins.
}
\description{
The \code{y} vector is averaged in bins defined for \code{x}.  Missing
values in \code{y} are ignored.
}
\examples{
library(oce)
# A. fake linear data
x <- seq(0, 100, 1)
y <- 1 + 2 * x
plot(x, y, pch=1)
ba <- binAverage(x, y)
points(ba$x, ba$y, pch=3, col="red", cex=3)

# B. fake quadratic data
y <- 1 + x ^2
plot(x, y, pch=1)
ba <- binAverage(x, y)
points(ba$x, ba$y, pch=3, col="red", cex=3)

# C. natural data
data(co2)
plot(co2)
avg <- binAverage(time(co2), co2, 1950, 2000, 2)
points(avg$x, avg$y, col="red")

}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binApply2D}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
