% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{initializeFlagScheme,ctd-method}
\alias{initializeFlagScheme,ctd-method}
\title{Establish a data-quality scheme for a ctd object}
\usage{
\S4method{initializeFlagScheme}{ctd}(
  object,
  name = NULL,
  mapping = NULL,
  default = NULL,
  update = NULL,
  debug = 0
)
}
\arguments{
\item{object}{An oce object.}

\item{name}{a character value naming the scheme. If this refers
to a pre-defined scheme, then \code{mapping} must not be provided,
because doing so would contradict the pre-defined scheme, defeating
its purpose of providing concreteness and clarity.}

\item{mapping}{a list of named items describing the mapping from
flag meaning to flag numerical value, e.g \code{list(good=1, bad=2)}
might be used for a hypothetical class.}

\item{default}{an integer vector of flag values that are not considered
to be good. If this is not provided, but if \code{name} is \code{"argo"},
\code{"BODC"},
\code{"DFO"},
\code{"WHP bottle"}, or
\code{"WHP CTD"}, then a conservative value will be set automatically,
equal to the list of flag values that designate bad or questionable data.
For example, for \code{name="WHP CTD"}, the setting will be
\code{c(1,3,4,5,6,7,9)}, leaving only value \code{2}, which corresponds
with "acceptable" in the notation used for that flag scheme.}

\item{update}{a logical value indicating whether the scheme provided is
to update an existing scheme.  The default value, \code{FALSE}, prevents such
an attempt to alter an existing flag scheme, if one is already embedded
in \code{object}.}

\item{debug}{an integer set to 0 for quiet action or to 1 for some debugging.}
}
\value{
An object with the \code{metadata} slot containing \code{flagScheme}.
}
\description{
This function stores add an item named \code{flagScheme}
to the \code{metadata} slot of an object inheriting from
\linkS4class{ctd}. This is a list containing two
items: \code{name} and \code{mapping}, as provided in the
function arguments.
The purpose is both to document a flag scheme
and to make it so that \code{\link[=initializeFlags]{initializeFlags()}},
\code{\link[=setFlags]{setFlags()}} and \code{\link[=handleFlags]{handleFlags()}}
can specify flags by
name, as opposed to number. This is a generic function,
that may be specialized to the class of \code{object}
(see \dQuote{Details}).
}
\details{
The following pre-defined schemes are available (note that the
names are simplified from the phrases used in defining
documentation):
\itemize{
\item \code{name="argo"} defaults \code{mapping} to
OLD (prior to June 10, 2020)
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(not_assessed=0, passed_all_tests=1, probably_good=2,
     probably_bad=3, bad=4, averaged=7,
     interpolated=8, missing=9)
}\if{html}{\out{</div>}}

NEW (after June 10, 2020)

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(not_assessed=0, passed_all_tests=1, probably_good=2,
     probably_bad=3, bad=4, changed=5, not_used_6=6, not_used_7=7,
     estimated=8, missing=9)
}\if{html}{\out{</div>}}

See reference 1 for a deeper explanation of the meanings of these codes.
\itemize{
\item \code{name="BODC"} defaults \code{mapping} to
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(no_quality_control=0, good=1, probably_good=2,
     probably_bad=3, bad=4, changed=5,
     below_detection=6, in_excess=7, interpolated=8,
     missing=9)
}\if{html}{\out{</div>}}

See reference 2 for a deeper explanation of the meanings of these codes,
and note that codes \code{A} and \code{Q} are not provided in
oce.
\itemize{
\item \code{name="DFO"} defaults \code{mapping} to
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(no_quality_control=0, appears_correct=1, appears_inconsistent=2,
     doubtful=3, erroneous=4, changed=5,
     qc_by_originator=8, missing=9)
}\if{html}{\out{</div>}}

See reference 3 for a deeper explanation of the meanings of these codes.
\itemize{
\item \code{name="WHP bottle"} defaults \code{mapping} to
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(no_information=1, no_problems_noted=2, leaking=3,
     did_not_trip=4, not_reported=5, discrepency=6,
     unknown_problem=7, did_not_trip=8, no_sample=9)
}\if{html}{\out{</div>}}

See reference 4 for a deeper explanation of the meanings of these codes.
\itemize{
\item \code{name="WHP CTD"} defaults \code{mapping} to
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(not_calibrated=1, acceptable=2, questionable=3,
    bad=4, not_reported=5, interpolated=6,
    despiked=7, missing=9)
}\if{html}{\out{</div>}}

See reference 4 for a deeper explanation of the meanings of these codes.
}
\references{
\enumerate{
\item The codes for \code{"argo"} are derived from information in Table 4.1
of Wong, Annie, Robert Keeley, Thierry Carval, and Argo Data Management Team
(8 January 2020), "Argo Quality Control Manual for CTD and Trajectory Data, Version 3.3,"
available at \verb{https://archimer.ifremer.fr/doc/00228/33951/}
as of June 2020.
\item The codes for \code{"BODC"} are defined at
http://seadatanet.maris2.nl/v_bodc_vocab_v2/browse.asp?order=conceptid&formname=search&screen=0&lib=l20
\item The codes for \code{"DFO"} are defined at
http://www.dfo-mpo.gc.ca/science/data-donnees/code/list/014-eng.html
\item The codes for \code{"WHP CTD"} and \code{"WHP bottle"} are defined at
https://www.nodc.noaa.gov/woce/woce_v3/wocedata_1/whp/exchange/exchange_format_desc.htm
}
}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{defaultFlags}()},
\code{\link{handleFlags,adp-method}},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags,section-method}},
\code{\link{handleFlags}()},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{initializeFlags}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags,oce-method}},
\code{\link{setFlags}()}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\concept{functions relating to data-quality flags}
\concept{things related to ctd data}
