% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{retime}
\alias{retime}
\title{Adjust the time within Oce object}
\usage{
retime(x, a, b, t0, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an \linkS4class{oce} object.}

\item{a}{intercept (in seconds) in linear model of time drift (see
\dQuote{Details}).}

\item{b}{slope (unitless) in linear model of time drift (unitless) (see
\dQuote{Details}).}

\item{t0}{reference time (in \code{\link[=POSIXct]{POSIXct()}} format) used in linear model of time
drift (see \dQuote{Details}).}

\item{debug}{a flag that, if nonzero, turns on debugging.}
}
\value{
A new object, with time and other data adjusted.
}
\description{
This function compensates for drifting instrument clocks, according to
\eqn{t'=t + a + b (t-t0)}{t'=t + a + b*(t-t0)}, where \eqn{t'}{t'} is the
true time and \eqn{t}{t} is the time stored in the object.  A single check
on time mismatch can be described by a simple time offset, with a non-zero
value of \code{a}, a zero value of \code{b}, and an arbitrary value of
\code{t0}.  Checking the mismatch before and after an experiment yields
sufficient information to specify a linear drift, via \code{a}, \code{b},
and \code{t0}.  Note that \code{t0} is just a convenience parameter, which
avoids the user having to know the "zero time" used in R and clarifies the
values of the other two parameters.  It makes sense for \code{t0} to have
the same timezone as the time within \code{x}.
}
\details{
The returned object is computed by linear interpolation, using
\code{\link[=approx]{approx()}} with \code{rule=2}, to avoid \code{NA} values at the
start or end.  The new time will be as given by the formula above. Note that
if the drift is large enough, the sampling rate will be changed.  It is a
good idea to start with an object that has an extended time range, so that,
after this is called, \code{\link[=subset]{subset()}} can be used to trim to a desired
time range.
}
\examples{
library(oce)
data(adv)
adv2 <- retime(adv,0,1e-4,as.POSIXct("2008-07-01 00:00:00", tz="UTC"))
plot(adv[["time"]], adv2[["time"]]-adv[["time"]], type="l")
}
\author{
Dan Kelley
}
