% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{usrLonLat}
\alias{usrLonLat}
\title{Calculate Geographic Coordinates of Plot Box}
\usage{
usrLonLat(n = 25, debug = getOption("oceDebug"))
}
\arguments{
\item{n}{number of points to check along each side of the plot box}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A list containing numerical
values \code{lonmin}, \code{lonmax}, \code{latmin}, and \code{latmax}, along
with logical value \code{ok}. The last of these indicates
whether at least one point on the plot box is invertible.
Note that longitudes are in the range from -180 to 180 degrees.
}
\description{
Trace along the plot box, converting from xy coordinates to lonlat
coordinates. The results are used by \code{\link[=mapGrid]{mapGrid()}}
and \code{\link[=mapAxis]{mapAxis()}} to ignore out-of-frame grid
lines and axis labels.
}
\details{
Some projections, such as \code{"wintri"}, have trouble inverting
points that are "off the globe".  In such cases,
the returned value has \code{lonmin}, \code{lonmax}, \code{latmin} and
\code{latmax} set to \code{NA}, and \code{ok} set to \code{FALSE}.
}
\seealso{
Other functions related to maps: 
\code{\link{formatPosition}()},
\code{\link{lonlat2map}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapAxis}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapPolygon}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{shiftLongitude}()},
\code{\link{utm2lonlat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
