#' GEOSECS station 235 data
#'
#' `geosecs235` is station 235 of the GEOSECS mission, with data downloaded
#'  from Reference 1, and referred to in Kelley and Van Scoy (1999).
#'
#' @name geosecs235
#'
#' @docType data
#'
#' @usage data(geosecs235, package="ocedata")
#'
#' @examples
#' data(geosecs235, package="ocedata")
#'\dontrun{
#' # Create a plot similar to Figure 10 of Kelley and Van Scoy (1999)
#' oce::plotProfile(geosecs235, xtype="tritium", type='p', ylim=c(600, 0))
#'}
#'
#' @references
#' 1. \code{https://iridl.ldeo.columbia.edu/SOURCES/.GEOSECS/ISTA/235/VALUE/}
#'
#' 2. D. E. Kelley and Van Scoy, K. A., 1999.  A basin-wide estimate of
#' vertical mixing in the upper pycnocline: spreading of bomb tritium in the
#' North Pacific Ocean.  *Journal of Physical Oceanography*,
#' 29:1759--1771.
NULL

