% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_filter}
\alias{od_filter}
\title{Filter OD datasets}
\usage{
od_filter(x, codes, silent = FALSE)
}
\arguments{
\item{x}{A data frame in which the first two columns are codes
representing points/zones of origin and destination}

\item{codes}{The zone codes that must be in origins and destination}

\item{silent}{Hide messages? \code{FALSE} by default.}
}
\value{
A data frame
}
\description{
This function takes and OD dataset and a character vector of codes
and returns an OD dataset with rows matching origin and destinations
zones present in the codes.
}
\examples{
x = od_data_df
z = od_data_zones
codes = z[[1]]
z_in_x_o = codes \%in\% x[[1]]
z_in_x_d = codes \%in\% x[[2]]
sum(z_in_x_d)
sum(z_in_x_o)
z = z[which(z_in_x_o | z_in_x_d)[-1], ]
z[[1]]
unique(c(x[[1]], x[[2]]))
try(od_to_sf(x, z)) # fails
nrow(x)
x = od_filter(x, z[[1]])
nrow(x)
od_to_sf(x, z)
}
