% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{class}
\name{OdbcConnection}
\alias{OdbcConnection}
\alias{OdbcConnection-class}
\alias{show,OdbcConnection-method}
\alias{dbIsValid,OdbcConnection-method}
\alias{dbDisconnect,OdbcConnection-method}
\alias{dbSendQuery,OdbcConnection,character-method}
\alias{dbSendStatement,OdbcConnection,character-method}
\alias{dbDataType,OdbcConnection,ANY-method}
\alias{dbQuoteString,OdbcConnection,character-method}
\alias{dbQuoteIdentifier,OdbcConnection,character-method}
\alias{dbListTables,OdbcConnection-method}
\alias{dbExistsTable,OdbcConnection,character-method}
\alias{dbListFields,OdbcConnection,character-method}
\alias{dbRemoveTable,OdbcConnection,character-method}
\alias{dbGetInfo,OdbcConnection-method}
\alias{dbGetQuery,OdbcConnection,character-method}
\alias{dbBegin,OdbcConnection-method}
\alias{dbCommit,OdbcConnection-method}
\alias{dbRollback,OdbcConnection-method}
\title{Odbc Connection Methods}
\usage{
\S4method{show}{OdbcConnection}(object)

\S4method{dbIsValid}{OdbcConnection}(dbObj, ...)

\S4method{dbDisconnect}{OdbcConnection}(conn, ...)

\S4method{dbSendQuery}{OdbcConnection,character}(conn, statement, ...)

\S4method{dbSendStatement}{OdbcConnection,character}(conn, statement, ...)

\S4method{dbDataType}{OdbcConnection,ANY}(dbObj, obj, ...)

\S4method{dbQuoteString}{OdbcConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{OdbcConnection,character}(conn, x, ...)

\S4method{dbListTables}{OdbcConnection}(conn, ...)

\S4method{dbExistsTable}{OdbcConnection,character}(conn, name, ...)

\S4method{dbListFields}{OdbcConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{OdbcConnection,character}(conn, name, ...)

\S4method{dbGetInfo}{OdbcConnection}(dbObj, ...)

\S4method{dbGetQuery}{OdbcConnection,character}(conn, statement, ...)

\S4method{dbBegin}{OdbcConnection}(conn, ...)

\S4method{dbCommit}{OdbcConnection}(conn, ...)

\S4method{dbRollback}{OdbcConnection}(conn, ...)
}
\arguments{
\item{object}{Any R object}

\item{dbObj}{An object inheriting from \code{\linkS4class{DBIObject}},
i.e. \code{\linkS4class{DBIDriver}}, \code{\linkS4class{DBIConnection}},
or a \code{\linkS4class{DBIResult}}}

\item{...}{Other arguments to methods.}

\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{obj}{An R object whose SQL type we want to determine.}

\item{x}{A character vector to label as being escaped SQL.}

\item{name}{A character string specifying a DBMS table name.}
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package
for OdbcConnection objects.
}
