% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl.smooth.gam.R
\name{pl.smooth.gam}
\alias{pl.smooth.gam}
\title{Plot smoothing functions of GAM(M) models}
\usage{
pl.smooth.gam(model, pred, col.line = "blue", ci.line.col = "black",
  ci.line.type = "dashed", ci.fill = "grey", ci.alpha = 0.4,
  ci.line.size = 0.8, sm.fun.size = 1.1, title = NULL, xlab = NULL,
  ylab = NULL, limits.y = NULL, breaks.y = NULL)
}
\arguments{
\item{model}{A fitted model of class \code{gam}.}

\item{pred}{The predictor of the fitted model to plot the smooth function of.}

\item{col.line}{Character. Sets color for smoothing function. Default to \code{"blue"}.}

\item{ci.line.col}{Character. Sets color for confident interval line of smoothing function. Default to \code{"black"}}

\item{ci.line.type}{Character. Sets linetype of confident interval line of smoothing function. Default to \code{"dashed"}.}

\item{ci.fill}{Character. Fill color of area between smoothing function and its confident interval lines.}

\item{ci.alpha}{Numeric [0,1]. Opacity value of confidence interval shading.}

\item{ci.line.size, sm.fun.size}{Line sizes.}

\item{title}{Character. Plot title.}

\item{xlab}{Character. X-axis title.}

\item{ylab}{Character. Y-axis title.}

\item{limits.y}{Numeric of length two. Sets y-axis limits.}

\item{breaks.y}{Numeric of length three. Sets y-axis breaks. See \code{\link[base]{seq}}. 
Values need to be given in a 'seq()' call, e.g. seq(-6,6,2).}
}
\description{
This function plots the smoothing function of selected GAM(M) models
using the \code{ggplot2} plotting system.
}
\examples{
# load data (Source: ?mgcv::gam) and fit model
library(mgcv)
fit.gam <- mgcv::gam(y ~ s(x0) + s(I(x1^2)) + s(x2) + offset(x3) + x4, data = data.gam)

library(oddsratio)
pl.smooth.gam(fit.gam, pred = "x2", title = "Predictor 'x2'")

}
\author{
Patrick Schratz <patrick.schratz@gmail.com>
}
\seealso{
\code{\link[oddsratio]{pl.smooth.gam}}

\code{\link[oddsratio]{calc.oddsratio.gam}}

\code{\link[oddsratio]{add.oddsratio.into.plot}}
}

