% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_validation.R
\name{check_correlation_matrix}
\alias{check_correlation_matrix}
\alias{assert_correlation_matrix}
\title{Check if an argument is a correlation matrix}
\usage{
check_correlation_matrix(x, dim = NULL)

assert_correlation_matrix(
  x,
  dim = NULL,
  .var.name = checkmate::vname(x),
  add = NULL
)
}
\arguments{
\item{x}{Object to check.}

\item{dim}{An \code{integer}, the matrix dimension.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
Compare to \code{\link[checkmate]{check_matrix}}.
}
\description{
This function checks whether the input is a symmetric, real matrix that
fulfills the correlation matrix properties.
}
