% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_helpers.R
\name{Index}
\alias{Index}
\title{Index R6 Object}
\value{
The output depends on the method:
\itemize{
\item \code{$new()} returns an \code{Index} object.
\item \code{$add()}, \code{$remove()}, and \code{$print()} invisibly return the
\code{Index} object (to allow for method chaining)
\item \code{$get()} returns the requested element(s)
\item \code{$number()} returns an \code{integer}
\item \code{$indices()} return an \code{integer} \code{vector}
}
}
\description{
Provides a simple indexing interface for list elements based on R6.
Basically, it allows to store items in a list and to regain them based on
identifiers defined by the user.
}
\section{Setting identifiers}{

An identifier is a \code{character}, typically a binary property. Identifiers
can be negated by placing an exclamation mark (\code{"!"}) in front of them.
Identifiers that have been assigned to other elements previously do not need
to be specified again for new elements; instead, a default value can be used.
This default value can be defined either globally for all cases (via the
\code{$missing_identifier} field) or separately for each specific case (via
the method argument).
}

\section{User confirmation}{

If desired, the user can be asked for confirmation when adding, extracting,
or removing elements using identifiers. This behavior can be set globally
through the \code{$confirm} field or customized separately for each specific
case via the method argument.
}

\examples{
### 1. Create an `Index` object:
my_index <- Index$new()

# 2. Add elements along with identifiers:
my_index$
  add(42, c("number", "rational"))$
  add(pi, c("number", "!rational"))$
  add("fear of black cats", c("text", "!rational"))$
  add("wearing a seat belt", c("text", "rational"))$
  add(mean, "function")

# 3. What elements are stored?
print(my_index)

# 4. Extract elements based on identifiers:
my_index$get("rational")
my_index$get("!rational")
my_index$get(c("text", "!rational"))
my_index$get(ids = 4:5, id_names = TRUE)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector}, the identifiers used}

\item{\code{confirm}}{setting the default value for confirmations (either
\code{TRUE} or \code{FALSE})}

\item{\code{missing_identifier}}{setting the default value for not specified
identifiers (either \code{TRUE}, \code{FALSE}, or \code{NA})}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Index-new}{\code{Index$new()}}
\item \href{#method-Index-add}{\code{Index$add()}}
\item \href{#method-Index-get}{\code{Index$get()}}
\item \href{#method-Index-remove}{\code{Index$remove()}}
\item \href{#method-Index-number}{\code{Index$number()}}
\item \href{#method-Index-indices}{\code{Index$indices()}}
\item \href{#method-Index-print}{\code{Index$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-new"></a>}}
\if{latex}{\out{\hypertarget{method-Index-new}{}}}
\subsection{Method \code{new()}}{
initializing an \code{Index} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a new \code{Index} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-add"></a>}}
\if{latex}{\out{\hypertarget{method-Index-add}{}}}
\subsection{Method \code{add()}}{
adding an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$add(
  x,
  identifier = character(),
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{any object to be saved}

\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Index} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-get"></a>}}
\if{latex}{\out{\hypertarget{method-Index-get}{}}}
\subsection{Method \code{get()}}{
getting elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$get(
  identifier = character(),
  ids = integer(),
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  id_names = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers}

\item{\code{ids}}{an \code{integer} \code{vector} of one or more ids}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{id_names}}{either \code{TRUE} to name the elements according to their ids or
\code{FALSE} if not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the selected object(s)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Index-remove}{}}}
\subsection{Method \code{remove()}}{
removing elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$remove(
  identifier = character(),
  ids = integer(),
  confirm = interactive() & self$confirm,
  missing_identifier = self$missing_identifier,
  shift_ids = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers}

\item{\code{ids}}{an \code{integer} \code{vector} of one or more ids}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{shift_ids}}{either \code{TRUE} to shift ids when in-between elements are removed,
or \code{TRUE} to keep the ids}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Index} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-number"></a>}}
\if{latex}{\out{\hypertarget{method-Index-number}{}}}
\subsection{Method \code{number()}}{
computing the number of identified elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$number(
  identifier = character(),
  missing_identifier = self$missing_identifier,
  confirm = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers}

\item{\code{missing_identifier}}{the \code{logical} value for not specified identifiers (either \code{NA},
\code{TRUE}, or \code{FALSE})}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{integer}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-indices"></a>}}
\if{latex}{\out{\hypertarget{method-Index-indices}{}}}
\subsection{Method \code{indices()}}{
returning indices based on defined identifiers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$indices(identifier = character(), confirm = interactive() & self$confirm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{a \code{character} \code{vector} with one or more identifiers}

\item{\code{confirm}}{either \code{TRUE} to be prompted for confirmation, or \code{FALSE} else}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{integer} \code{vector}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Index-print"></a>}}
\if{latex}{\out{\hypertarget{method-Index-print}{}}}
\subsection{Method \code{print()}}{
printing details of the saved elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Index$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{currently not used}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly the \code{Index} object
}
}
}
