% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_docx.R
\name{read_docx}
\alias{read_docx}
\alias{print.docx}
\alias{length.docx}
\title{open a connexion to a 'Word' file}
\usage{
read_docx(path = NULL)

\method{print}{docx}(x, target = NULL, ...)

\method{length}{docx}(x)
}
\arguments{
\item{path}{path to the docx file to use a base document.}

\item{x}{a docx object}

\item{target}{path to the docx file to write}

\item{...}{unused}
}
\description{
read and import a docx file as an R object
representing the document.
}
\examples{
# create a docx object with default template ---
read_docx()

# write a docx object in a docx file ----
if( require(magrittr) ){
  read_docx() \%>\% print(target = "out.docx")
  # full path of produced file is returned
  print(.Last.value)
}

# how many element are there in the document ----
length( read_docx() )

}
