% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{slide_summary}
\alias{slide_summary}
\title{get PowerPoint slide content in a tidy format}
\usage{
slide_summary(x, index = NULL)
}
\arguments{
\item{x}{rpptx object}

\item{index}{slide index}
}
\description{
get content and positions of current slide
into a data.frame. If any table, image or paragraph, data is
imported into the resulting data.frame.
}
\examples{
library(magrittr)

my_pres <- read_pptx() \%>\%
  add_slide(layout = "Two Content", master = "Office Theme") \%>\%
  ph_with_text(type = "dt", str = format(Sys.Date())) \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme")

slide_summary(my_pres)
slide_summary(my_pres, index = 1)
}
