% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_linebreak}
\alias{run_linebreak}
\title{page break for Word}
\usage{
run_linebreak()
}
\description{
Object representing a line break for a Word document. The
result must be used within a call to \link{fpar}.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{

fp_t <- fp_text(font.size = 12, bold = TRUE)
an_fpar <- fpar("let's add a line break", run_linebreak(), ftext("and blah blah!", fp_t))

x <- read_docx()
x <- body_add(x, an_fpar)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_footnoteref}()},
\code{\link{run_footnote}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()}
}
\concept{run functions for reporting}
