% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_notes.R
\name{set_notes}
\alias{set_notes}
\alias{set_notes.character}
\alias{set_notes.block_list}
\title{Set notes for current slide}
\usage{
set_notes(x, value, location, ...)

\method{set_notes}{character}(x, value, location, ...)

\method{set_notes}{block_list}(x, value, location, ...)
}
\arguments{
\item{x}{an rpptx object}

\item{value}{text to be added to notes}

\item{location}{a placeholder location object.
It will be used to specify the location of the new shape. This location
can be defined with a call to one of the notes_ph functions. See
section \code{"see also"}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Set speaker notes for the current slide in a pptx presentation.
}
\section{Methods (by class)}{
\itemize{
\item \code{set_notes(character)}: add a character vector to a place holder in the notes on the
current slide, values will be added as paragraphs.

\item \code{set_notes(block_list)}: add a \code{\link[=block_list]{block_list()}} to a place holder in the notes on the
current slide.

}}
\examples{
# this name will be used to print the file
# change it to "youfile.pptx" to write the pptx
# file in your working directory.
fileout <- tempfile(fileext = ".pptx")
fpt_blue_bold <- fp_text_lite(color = "#006699", bold = TRUE)
doc <- read_pptx()
# add a slide with some text ----
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with(x = doc, value = "Slide Title 1",
   location = ph_location_type(type = "title") )
# set speaker notes for the slide ----
doc <- set_notes(doc, value = "This text will only be visible for the speaker.",
   location = notes_location_type("body"))

# add a slide with some text ----
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with(x = doc, value = "Slide Title 2",
   location = ph_location_type(type = "title") )
bl <- block_list(
  fpar(ftext("hello world", fpt_blue_bold)),
  fpar(ftext("Turlututu chapeau pointu", fpt_blue_bold))
)
doc <- set_notes(doc, value = bl,
   location = notes_location_type("body"))

print(doc, target = fileout)

}
\seealso{
\code{\link[=print.rpptx]{print.rpptx()}}, \code{\link[=read_pptx]{read_pptx()}}, \code{\link[=add_slide]{add_slide()}}, \code{\link[=notes_location_label]{notes_location_label()}}, \code{\link[=notes_location_type]{notes_location_type()}}

Other functions to manipulate slides:
\code{\link{add_slide}()},
\code{\link{move_slide}()},
\code{\link{on_slide}()},
\code{\link{remove_slide}()}
}
\concept{slide_manipulation}
