% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dheatmap.R
\name{dheatmap}
\alias{dheatmap}
\title{Heatmap Plot}
\usage{
dheatmap(d_matrix, colors = c("white", "lightblue", "blue", "darkblue",
  "black"), mode = "linear", tick.labels = TRUE, nbins = 5)
}
\arguments{
\item{d_matrix}{A matrix of D statistics or a matrix of D statistic ratios.}

\item{colors}{An optional color vector. Optionally modify the color scheme of the heatmap. If mode = 'binned', must be of length 5.}

\item{mode}{A string indicating desired coloring scheme. The option "linear" scales
colors linearly, "truncated" truncates values greater than 1, and "binned" returns
a discretedistribution of colors.}

\item{tick.labels}{A logical indicating whether or not marker labels should be drawn.}

\item{nbins}{An integer specifying the number of bins to be used. Only relevent if mode is "binned".}
}
\value{
A color plot
}
\description{
Plots a matrix of D statistics, output from dwrapper, as a heatmap.
}
\details{
The d_matrix input should be one of the matrices output by dwrapper. Options are d2it_mat, d2is_mat, d2st_mat, dp2st_mat, dp2is_mat, npops_mat, ratio1, and ratio2.
More customized plots can be developed using the "levelplot" package.
}
\examples{
data(miyashita_langley_data)
miyashita_langley_subset <- miyashita_langley_data[,1:15]
ml_results <- dwrapper(miyashita_langley_subset)
dheatmap(ml_results[["d2it_mat"]], mode = 'linear')

\dontrun{
data(miyashita_langley_data)
ml_results <- dwrapper(miyashita_langley_data)
dheatmap(ml_results[["d2it_mat"]], mode = 'linear')
}

}
