% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-plus-component-plot.R
\name{ols_rpc_plot}
\alias{ols_rpc_plot}
\title{Residual Plus Component Plot}
\usage{
ols_rpc_plot(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\description{
The residual plus component plot indicates whether any non-linearity is present
in the relationship between response and predictor variables and can suggest possible transformations
for linearizing the data.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_rpc_plot(model)
}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}

