% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-residual-fit-spread-plot.R
\name{ols_rfs_plot}
\alias{ols_rfs_plot}
\alias{ols_fm_plot}
\alias{ols_rsd_plot}
\title{Residual Fit Spread Plot}
\usage{
ols_rfs_plot(model)

ols_fm_plot(model)

ols_rsd_plot(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\description{
Plot to detect non-linearity, influential observations and outliers.
}
\details{
Consists of side-by-side quantile plots of the centered fit and the residuals. It shows how 
much variation in the data is explained by the fit and how much remains in the residuals. For 
inappropriate models, the spread of the residuals in such a plot is often greater than the spread of the
centered fit.
}
\examples{
# model
model <- lm(mpg ~ disp + hp + wt, data = mtcars)

# residual fit spread plot
ols_rfs_plot(model)

# fit mean plot
ols_fm_plot(model)

# residual spread plot
ols_rsd_plot(model)

}
\references{
Cleveland, W. S. (1993). Visualizing Data. Summit, NJ: Hobart Press.
}
