% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-plots-data.R
\name{ols_prep_dfbeta_outliers}
\alias{ols_prep_dfbeta_outliers}
\title{DFBETAs plot outliers}
\usage{
ols_prep_dfbeta_outliers(d)
}
\arguments{
\item{d}{A \code{tibble} or \code{data.frame}.}
}
\description{
Data for identifying outliers in dfbetas plot.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
dfb <- dfbetas(model)
n <- nrow(dfb)
threshold <- 2 / sqrt(n)
dbetas  <- dfb[, 1]
df_data <- tibble::tibble(obs = seq_len(n), dbetas = dbetas)
d <- ols_prep_dfbeta_data(df_data, threshold)
ols_prep_dfbeta_outliers(d)

}
