% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_boxplot.R
\name{plot_boxplot}
\alias{plot_boxplot}
\title{Create a box plot}
\usage{
plot_boxplot(
  count_data,
  metadata,
  aggregate_by,
  log_transform,
  Factor,
  response_variable,
  fill_list
)
}
\arguments{
\item{count_data}{A metabolomics count data frame, either from read_metabo or omu_summary}

\item{metadata}{The descriptive meta data for the samples}

\item{aggregate_by}{Hierarchical metadata value to sum metabolite values by, i.e. "Class"}

\item{log_transform}{TRUE or FALSE. Recommended for visualization purposes. If true data is
transformed by the natural log}

\item{Factor}{The column name for the experimental variable}

\item{response_variable}{The response variable for the data, i.e. "Metabolite"}

\item{fill_list}{Colors for the plot which is colored by Factor, in the form of c("")}
}
\description{
Takes a metabolomics count data frame and creates boxplots. It is recommended to
either subset, truncate, or agglomerate by hierarchical metadata.
}
\examples{
c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:5,]
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")

plot_boxplot(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
log_transform = TRUE, Factor = "Treatment", response_variable = "Metabolite",
aggregate_by = "Subclass_2", fill_list = c("darkgoldenrod1", "dodgerblue2"))
}
