% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_report_format.R
\name{fetch_report_format}
\alias{fetch_report_format}
\title{Fetch The Specified Report Formatting Information}
\usage{
fetch_report_format(obnd, format_name = "default", verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{format_name}{Name of report format to fetch; this is defined in the md_def}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned list.
section for the given report type (\code{"default"})}
}
\value{
list containing the following elements
\itemize{
\item{isgood}: Boolean variable indicating success or failure
\item{msgs}: Vector of messages
\item{format_details}: List containing the format details for the specified
format_name
}
}
\description{
Returns a list of the default font format for the report element
}
\examples{
obnd = read_template(
       template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
        mapping = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

fr = fetch_report_format(obnd)
}
