% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_table.R
\name{build_span}
\alias{build_span}
\title{Construct Table Span From Components}
\usage{
build_span(
  table_body = NULL,
  row_common = NULL,
  table_body_head = NULL,
  row_common_head = NULL,
  header_format = "text",
  obnd = NULL,
  row_sel = NULL,
  col_sel = NULL,
  table_alignment = "center",
  inner_border = officer::fp_border(color = "black", width = 0.3),
  outer_border = officer::fp_border(color = "black", width = 2),
  set_header_inner_border_v = TRUE,
  set_header_inner_border_h = TRUE,
  set_header_outer_border = TRUE,
  set_body_inner_border_v = TRUE,
  set_body_inner_border_h = FALSE,
  set_body_outer_border = TRUE,
  notes_detect = NULL
)
}
\arguments{
\item{table_body}{Data frame with the body of the large table.}

\item{row_common}{Data frame with the common rows.}

\item{table_body_head}{Data frame or matrix with headers for the table body.}

\item{row_common_head}{Data frame or matrix with headers for the common rows.}

\item{header_format}{Format of the header either \code{"text"} (default) or \code{"md"} for markdown.}

\item{obnd}{Optional onbrand object used to format markdown. The default \code{NULL} value will use default formatting.}

\item{row_sel}{Indices of rows to build to the table with.}

\item{col_sel}{Indices of columns to build to the table with.}

\item{table_alignment}{Character string specifying the alignment #'of the table (body and headers). Can be \code{"center"} (default), \code{"left"}, \code{"right"}, or \code{"justify"}}

\item{inner_border}{Border object for inner border lines defined using \code{officer::fp_border()}}

\item{outer_border}{Border object for outer border lines defined using \code{officer::fp_border()}}

\item{set_header_inner_border_v}{Boolean value to enable or disable inner vertical borders for headers}

\item{set_header_inner_border_h}{Boolean value to enable or disable inner horizontal borders for headers}

\item{set_header_outer_border}{Boolean value to enable or disable outer border for headers}

\item{set_body_inner_border_v}{Boolean value to enable or disable inner vertical borders for the body}

\item{set_body_inner_border_h}{Boolean value to enable or disable inner horizontal borders for the body}

\item{set_body_outer_border}{Boolean value to enable or disable outer border borders for the body}

\item{notes_detect}{Vector of strings to detect in output tables (example \code{c("NC", "BLQ")}).}
}
\value{
list with the following elements
\itemize{
  \item{df:}     Data frame with the built table.
  \item{ft:}     The data frame as a flextable object.
  \item{notes:}  Note placeholders found in the table.
}
}
\description{
Takes a large table, common rows, and header information and
constructs a table that is a subset of those components using supplied
ranges of rows and columns.
}
\details{
The way the data frames relate to each other are mapped out below. The
dimensions of the different data frames are identified below (nrow x ncol)


\preformatted{
                            col_sel
                      |<--------------->|

|--------------------------------------------| ---
|                 |   .                 .    |  ^
|                 |   .                 .    |  |
| row_common_head |   . table_body_head .    |  | m
|      m x n      |   .      m x c      .    |  |
|                 |   .                 .    |  v
|--------------------------------------------| ---
|                 |   .                 .    |  ^
|                 |   .                 .    |  |
|    row_common   |   .   table_body    .    |  |
|      r x n      |   .     r x c       .    |  |
|                 |   .                 .    |  |
|.................|..........................|  |     -
|                 |   ./  /  /  /  /  / .    |  |     ^
|                 |   .  /  /  /  /  /  .    |  | r   |
|                 |   . /  /  /  /  /  /.    |  |     | row_sel
|                 |   ./  /  /  /  /  / .    |  |     |
|                 |   .  /  /  /  /  /  .    |  |     v
|.................|...../../../../../../.... |  |     -
|                 |   .                 .    |  |
|                 |   .                 .    |  v
|--------------------------------------------| ---

|<--------------->|<------------------------>|
        n                    c
}
}
\examples{
if(interactive()){

tbl_res = mk_lg_tbl()

res =
span_table(table_body      = tbl_res$lg_tbl_body,
           row_common      = tbl_res$lg_tbl_row_common,
           table_body_head = tbl_res$lg_tbl_body_head,
           row_common_head = tbl_res$lg_tbl_row_common_head,
           max_row         = 20,
           max_col         = 10,
           notes_detect    = c("BQL", "NC"))


# Notes detected in the first table:
res[["tables"]][["Table 1"]][["notes"]]

# First table as a data frame:
res[["tables"]][["Table 1"]][["df"]]

# First table as a flextable:
res[["tables"]][["Table 1"]][["ft"]]

}

}
