% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mstate.R
\name{plot_mstate}
\alias{plot_mstate}
\title{Swimmer plot of multi-state data}
\usage{
plot_mstate(
  data,
  model,
  now = max(tbl_mstate$t_max),
  relative_to_sot = TRUE,
  ...
)
}
\arguments{
\item{data}{a data frame with multi-state data; variables are
\verb{subject_id<chr>}, \verb{group_id<chr>}, \verb{subject_id<chr>}, \verb{from<chr>},
\verb{to<chr>}, \verb{t_min<dbl>}, \verb{t_max<dbl>}, \verb{t_sot<dbl>}, where
\code{to} and \code{from} indicate the state from which and into which the transitions
occurs (stable, response, progression), \code{t_max} and \code{t_min} specify the
interval in which the transition occurred relative to \code{t_sot}
(start of treatment).}

\item{model}{an object of class \link{srpmodel} containing prior information}

\item{now}{the current time relative to the start of the trial}

\item{relative_to_sot}{logical, should the timeline be relative to the start
of trial or the start of treatment for each individual}

\item{...}{further arguments passed to method implementations}
}
\value{
a \link[ggplot2:ggplot]{ggplot2::ggplot} object
}
\description{
\code{plot_mstate()} plots data in 'multi-state-format' as swimmer plot.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
tbl_visits <- sample_predictive(mdl, n_per_group = 5L, nsim = 1, seed = 468L)
tbl_mstate <- visits_to_mstate(tbl_visits, mdl)
plot_mstate(tbl_mstate, mdl)

}
\seealso{
\code{\link[=visits_to_mstate]{visits_to_mstate()}}
}
