% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-oneinfl.R
\name{predict.oneinflmodel}
\alias{predict.oneinflmodel}
\title{Predicted Expected Response for One-Inflated or Truncated Models}
\usage{
\method{predict}{oneinflmodel}(object, ...)
}
\arguments{
\item{object}{An object of class \code{oneinflmodel}}

\item{...}{Additional argument \code{df}, a data frame used to calculate the expected
value of the response variable.}
}
\value{
A numeric vector of predicted expected responses for the observations in \code{df}.
}
\description{
Calculates the predicted expected response for a model fitted using
\code{\link{oneinfl}} or \code{\link{truncreg}}.
}
\details{
This function computes the expected response based on the fitted model. The computation
differs depending on the distribution. For \code{Poisson (OIPP)}, predicted values are
computed using \code{\link{E_pois}}. For \code{Negative Binomial (OIZTNB)}, predicted
values are computed using \code{\link{E_negbin}}.
}
\examples{
# Example usage
df <- data.frame(x = rnorm(100), z = rnorm(100), y = rpois(100, lambda = 5))
model <- oneinfl(y ~ x | z, df = df, dist = "Poisson")
predict(model, df = df)

}
\seealso{
\code{\link{oneinfl}} for fitting one-inflated models.
\code{\link{E_pois}}, \code{\link{E_negbin}}, for the expected value calculations.
}
