% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_seq.R
\name{order_seq}
\alias{order_seq}
\title{Search for the best order of markers combining compare and try_seq
functions}
\usage{
order_seq(input.seq, n.init = 5, subset.search = c("twopt", "sample"),
  subset.n.try = 30, subset.THRES = 3, twopt.alg = c("rec", "rcd",
  "ser", "ug"), THRES = 3, touchdown = FALSE, tol = 0.1)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{n.init}{the number of markers to be used in the \code{compare} step
(defaults to 5).}

\item{subset.search}{a character string indicating which method should be
used to search for a subset of informative markers for the
\code{\link{compare}} step. It is used for backcross, \eqn{F_2}{F_2} or RIL
populations, but not for outcrosses. See the \code{Details} section.}

\item{subset.n.try}{integer. The number of times to repeat the subset
search procedure. It is only used if \code{subset.search=="sample"}. See
the \code{Details} section.}

\item{subset.THRES}{numerical. The threshold for the subset search
procedure. It is only used if \code{subset.search=="sample"}. See the
\code{Details} section.}

\item{twopt.alg}{a character string indicating which two-point algorithm
should be used if \code{subset.search=="twopt"}. See the \code{Details}
section.}

\item{THRES}{threshold to be used when positioning markers in the
\code{try_seq} step.}

\item{touchdown}{logical. If \code{FALSE} (default), the \code{try_seq}
step is run only once, with the value of \code{THRES}. If \code{TRUE},
\code{try_seq} runs with \code{THRES} and then once more, with
\code{THRES-1}. The latter calculations take longer, but usually are able
to map more markers.}

\item{tol}{tolerance number for the C routine, i.e., the value used to
evaluate convergence of the EM algorithm.}
}
\value{
An object of class \code{order}, which is a list containing the
following components: \item{ord}{an object of class \code{sequence}
containing the "safe" order.} \item{mrk.unpos}{a \code{vector} with
unpositioned markers (if they exist).} \item{LOD.unpos}{a \code{matrix}
with LOD-Scores for unmapped markers, if any, for each position in the
"safe" order.} \item{THRES}{the same as the input value, just for
printing.} \item{ord.all}{an object of class \code{sequence} containing the
"forced" order, i.e., the best order with all markers.}
\item{data.name}{name of the object of class \code{onemap} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
For a given sequence of markers, this function first uses the
\code{compare} function to create a framework for a subset of informative
markers. Then, it tries to map remaining ones using the \code{try_seq}
function.
}
\details{
For outcrossing populations, the initial subset and the order in which
remaining markers will be used in the \code{try_seq} step is given by the
degree of informativeness of markers (i.e markers of type A, B, C and D, in
this order).

For backcrosses, F2s or RILs, two methods can be used for
choosing the initial subset: i) \code{"sample"} randomly chooses a number
of markers, indicated by \code{n.init}, and calculates the multipoint
log-likelihood of the \eqn{\frac{n.init!}{2}}{n.init!/2} possible orders.
If the LOD Score of the second best order is greater than
\code{subset.THRES}, than it takes the best order to proceed with the
\code{try_seq} step. If not, the procedure is repeated. The maximum number
of times to repeat this procedure is given by the \code{subset.n.try}
argument. ii) \code{"twopt"} uses a two-point based algorithm, given by the
option \code{"twopt.alg"}, to construct a two-point based map. The options
are \code{"rec"} for RECORD algorithm, \code{"rcd"} for Rapid Chain
Delineation, \code{"ser"} for Seriation and \code{"ug"} for Unidirectional
Growth. Then, equally spaced markers are taken from this map. The
\code{"compare"} step will then be applied on this subset of markers.

In both cases, the order in which the other markers will be used in the
\code{try_seq} step is given by marker types (i.e. co-dominant before
dominant) and by the missing information on each marker.

After running the \code{compare} and \code{try_seq} steps, which result in
a "safe" order, markers that could not be mapped are "forced" into the map,
resulting in a map with all markers positioned.
}
\examples{

\dontrun{
  #outcross example
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG2 <- make_seq(groups,2)
  LG2.ord <- order_seq(LG2,touchdown=TRUE)
  LG2.ord
  make_seq(LG2.ord) # get safe sequence
  make_seq(LG2.ord,"force") # get forced sequence

  #F2 example
  data(onemap_example_f2)
  twopt <- rf_2pts(onemap_example_f2)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG3 <- make_seq(groups,3)
  LG3.ord <- order_seq(LG3, subset.search = "twopt", twopt.alg = "rcd", touchdown=TRUE)
  LG3.ord
  make_seq(LG3.ord) # get safe sequence
  ord.1<-make_seq(LG3.ord,"force") # get forced sequence

  LG3.ord.s <- order_seq(LG3, subset.search = "sample", touchdown=TRUE)
  LG3.ord.s
  make_seq(LG3.ord) # get safe sequence
  ord.2<-make_seq(LG3.ord,"force") # get forced sequence

  rbind(ord.1$seq.num, ord.2$seq.num) # probably, the same order for
  this dataset
}
}
\references{
Broman, K. W., Wu, H., Churchill, G., Sen, S., Yandell, B.
(2008) \emph{qtl: Tools for analyzing QTL experiments} R package version
1.09-43

Jiang, C. and Zeng, Z.-B. (1997). Mapping quantitative trait loci with
dominant and missing markers in various crosses from two inbred lines.
\emph{Genetica} 101: 47-58.

Lander, E. S. and Green, P. (1987). Construction of multilocus genetic
linkage maps in humans. \emph{Proc. Natl. Acad. Sci. USA} 84: 2363-2367.

Lander, E. S., Green, P., Abrahamson, J., Barlow, A., Daly, M. J., Lincoln,
S. E. and Newburg, L. (1987) MAPMAKER: An interactive computer package for
constructing primary genetic linkage maps of experimental and natural
populations. \emph{Genomics} 1: 174-181.

Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia, A. A. F.
(2009) Evaluation of algorithms used to order markers on genetics maps.
\emph{Heredity} 103: 494-502.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002a) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.

Wu, R., Ma, C.-X., Wu, S. S. and Zeng, Z.-B. (2002b). Linkage mapping of
sex-specific differences. \emph{Genetical Research} 79: 85-96
}
\seealso{
\code{\link[onemap]{make_seq}}, \code{\link[onemap]{compare}} and
\code{\link[onemap]{try_seq}}.
}
\author{
Gabriel R A Margarido, \email{gramarga@usp.br} and Marcelo
Mollinari, \email{mmollina@gmail.com}
}
\keyword{utilities}
