% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_2pts.R
\name{rf_2pts}
\alias{rf_2pts}
\title{Two-point analysis between genetic markers}
\usage{
rf_2pts(input.obj, LOD = 3, max.rf = 0.5, verbose = TRUE)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}.}

\item{LOD}{minimum LOD Score to declare linkage (defaults to \code{3}).}

\item{max.rf}{maximum recombination fraction to declare linkage (defaults
to \code{0.50}).}

\item{verbose}{logical. If \code{TRUE}, current progress is shown; if
\code{FALSE}, no output is produced.}
}
\value{
An object of class \code{rf_2pts}, which is a list containing the
following components:  \item{n.mar}{total number of markers.} \item{LOD}{minimum LOD Score to declare
linkage.} \item{max.rf}{maximum recombination fraction to declare linkage.}
\item{input}{the name of the input file.} \item{analysis}{an array with the
complete results of the two-point analysis for each pair of markers.}
}
\description{
Performs the two-point (pairwise) analysis proposed by \cite{Wu et al.
(2002)} between all pairs of markers.
}
\details{
For \code{n} markers, there are \deqn{\frac{n(n-1)}{2}}{n*(n-1)/2} pairs of
markers to be analyzed. Therefore, completion of the two-point analyses can
take a long time.
}
\note{
The thresholds used for \code{LOD} and \code{max.rf} will be used in
subsequent analyses, but can be overriden.
}
\examples{

  data(onemap_example_out)

  twopts <- rf_2pts(onemap_example_out,LOD=3,max.rf=0.5) # perform two-point analyses
  twopts

  print(twopts,c("M1","M2")) # detailed results for markers 1 and 2
}
\references{
Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002)
Simultaneous maximum likelihood estimation of linkage and linkage phases in
outcrossing species. \emph{Theoretical Population Biology} 61: 349-363.
}
\author{
Gabriel R A Margarido \email{gramarga@gmail.com} and Marcelo Mollinari \email{mmollina@usp.br}
}
\keyword{utilities}
