## ----knitr_init, echo=FALSE, cache=FALSE--------------------------------------
library(knitr)
library(rmarkdown)

knitr::opts_chunk$set(collapse = TRUE,
                      comment = "#>",
                      fig.width = 6,
                      fig.height = 6,
                      fig.align = "center",
                      dev = "png",
                      dpi = 36,
                      cache = TRUE)


## -----------------------------------------------------------------------------
2 + 3

## -----------------------------------------------------------------------------
x <- 2 + 3

## -----------------------------------------------------------------------------
x

## -----------------------------------------------------------------------------
x + 4

## -----------------------------------------------------------------------------
log(6.7)

## -----------------------------------------------------------------------------
log(6.7, base = 4)

## -----------------------------------------------------------------------------
y <- c(6.7, 3.2, 5.4, 8.1, 4.9, 9.7, 2.5)
log(y)

## ---- eval=FALSE--------------------------------------------------------------
#  ?log

## ---- eval=FALSE--------------------------------------------------------------
#  setRepositories(ind = 1:2)
#  install.packages("onemap")

## -----------------------------------------------------------------------------
library(onemap)

## ---- eval=FALSE--------------------------------------------------------------
#  ERROR: dependency ‘tkrplot’ is not available for package ‘onemap’

## ---- eval=FALSE--------------------------------------------------------------
#  sudo apt-get install r-cran-tkrplot

## -----------------------------------------------------------------------------
rf <- c(0.01, 0.12, 0.05, 0.11, 0.21, 0.07)

## -----------------------------------------------------------------------------
kosambi(rf)

## ---- eval=FALSE--------------------------------------------------------------
#  ?kosambi

## ---- eval=FALSE--------------------------------------------------------------
#  dat <- read.table(file = "test.txt", header = TRUE)
#  dat

## ---- echo=FALSE--------------------------------------------------------------
dat <- data.frame(x = c(2.13,4.48,10.95,10.03,12.72,24.63,22.57,29.78,19.54,7.86,11.75,23.71),
                  y= c(4.5,1.98,9.29,16.25,27.38,22.6,36.87,31.73,10.42,14.68,8.68,37.39))


## -----------------------------------------------------------------------------
dat$x
dat$y 

## -----------------------------------------------------------------------------
summary(dat)
summary(dat$x)
summary(dat$y)

## ---- eval=FALSE--------------------------------------------------------------
#  write.table(x = summary(dat), file = "test_sum.txt", quote = FALSE)

## -----------------------------------------------------------------------------
class(dat)

## -----------------------------------------------------------------------------
ft_mod <- lm(dat$y ~ dat$x)
ft_mod

## -----------------------------------------------------------------------------
class(ft_mod)

## -----------------------------------------------------------------------------
summary(ft_mod)

## ---- eval=FALSE--------------------------------------------------------------
#  save.image("myworkspace.RData")

## ---- eval=FALSE--------------------------------------------------------------
#  load("myworkspace.RData")

