## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
library("onion") 

## -----------------------------------------------------------------------------
set.seed(0)
options(digits=2)
romat()

## -----------------------------------------------------------------------------
A <- matrix(rquat(21),7,3)  # matrix() calls onion::onionmat()
A

## -----------------------------------------------------------------------------
A[1,]

## -----------------------------------------------------------------------------
A[1,,drop=FALSE]

## -----------------------------------------------------------------------------
Re(A)
k(A)

## -----------------------------------------------------------------------------
j(A) <- -1
A

## -----------------------------------------------------------------------------
sum(A)

## -----------------------------------------------------------------------------
A <- matrix(rquat(21),3,7)
umbral <- state.abb[1:7]
rownames(A) <- letters[1:3]
colnames(A) <- umbral

B <- matrix(rquat(28),7,4)
rownames(B) <- umbral
colnames(B) <- c("H","He","Li","Be")

A %*% B

## -----------------------------------------------------------------------------
C <- matrix(rquat(14),7,2)
rownames(C) <- umbral
colnames(C) <- month.abb[1:2]
cprod(B,C)

## -----------------------------------------------------------------------------
tcprod(A) - A %*% ht(A)

## -----------------------------------------------------------------------------
x <- cprod(matrix(roct(12),4,3))
x

## -----------------------------------------------------------------------------
max(Mod(Im(x+t(x))))

## -----------------------------------------------------------------------------
`%o%` <- function(x,y){(x%*%y + y%*%x)/2}

## -----------------------------------------------------------------------------
x <- cprod(matrix(roct(12),4,3))
y <- cprod(matrix(roct(12),4,3))

## -----------------------------------------------------------------------------
jj <- x %o% y
max(Mod(Im(jj+t(jj))))

## -----------------------------------------------------------------------------
LHS <- (x %o% y) %o% (x %o% x)
RHS <- x %o% (y %o% (x %o% x))
max(Mod(LHS-RHS))  # zero to numerical precision

