% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-get.R
\name{ons_get}
\alias{ons_get}
\alias{ons_get_obs}
\title{Download data from ONS}
\usage{
ons_get(
  id = NULL,
  edition = NULL,
  version = NULL,
  ons_read = getOption("onsr.read"),
  ...
)

ons_get_obs(id = NULL, edition = NULL, version = NULL, ...)
}
\arguments{
\item{id}{\verb{[character]}     Id that represents a dataset.}

\item{edition}{\verb{[character]}     A subset of the dataset representing a specific time period.
For some datasets this edition can contain all time periods (all historical data).
The latest version of this is displayed by default.}

\item{version}{\verb{[character]}     A specific instance of the edition at a point in time. New
versions can be published as a result of corrections, revisions or new data
becoming available.}

\item{ons_read}{\verb{[character]}. Reading backend, one of \code{readr}, \code{data.table} or \code{vroom}.}

\item{...}{Further arguments passed on the methods.}
}
\value{
A tibble with the dataset in tidy format.
}
\description{
This functions is used to find information about data published by the ONS.
\code{Datasets} are published in unique \code{versions}, which are categorized by \code{edition}.
Available datasets are given  an \code{id}. All available \code{id} can be viewed with \code{ons_ids()}.
}
\examples{
\donttest{
ons_get(id = "cpih01")

# Same dataset but older version
ons_get(id = "cpih01", version = "5")
}
\donttest{
# Take only specific observations
ons_get_obs("cpih01", geography = "K02000001", aggregate = "cpih1dim1A0", time = "Oct-11")

# Or can use a wildcard for the time
ons_get_obs("cpih01", geography = "K02000001", aggregate = "cpih1dim1A0", time = "*")

}

}
