% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{merge_tree_cat_list}
\alias{merge_tree_cat_list}
\title{Merge state bins over a tree list}
\usage{
merge_tree_cat_list(tree.list)
}
\arguments{
\item{tree.list}{multiSimmap object.}
}
\value{
A list of trees with merged identical bins.
}
\description{
A wrapper function to merge identical state bins over a tree list.
}
\examples{
data("hym_stm")
tree_list <- hym_stm[[1]]
tree_list <- discr_Simmap_all(tree_list, res = 100)
stm_merg_list <- merge_tree_cat_list(tree_list)
# Check some arbitrary branch of some arbitrary tree.
br1 <- tree_list[[1]]$maps[[5]]
br1
br2 <- stm_merg_list[[1]]$maps[[5]]
br2
sum(br1) == br2

}
\author{
Diego S. Porto
}
