% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmo.annotations.R
\name{harmo.annotate.status}
\alias{harmo.annotate.status}
\title{Set variable annotation with Harmonization Status term}
\usage{
harmo.annotate.status(tibble, variables = NULL, status)
}
\arguments{
\item{tibble}{Tibble to be annotated.}

\item{variables}{A character vector of variable names to be annotated. If NULL or empty, all
the columns of the tibble will be annotated.}

\item{status}{The harmonization status to apply: 'complete', 'undetermined' or 'impossible'. If NULL, the annotation will be deleted.}
}
\value{
The annotated tibble
}
\description{
Apply or remove an harmonization status annotation from a set of variables. The harmonization status
is described by the "status" vocabulary in the "Mlstr_harmo" taxonomy.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
cqx <- harmo.table_get(o, "CPTP", "Cag_coreqx")
cqx <- harmo.annotate.status(cqx, 
  variables = c("A_SDC_EDU_LEVEL", "A_SDC_EDU_LEVEL_AGE"), 
  status = "complete")
opal.logout(o)
}
}
