% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.taxonomy.r
\name{opal.taxonomy_upload}
\alias{opal.taxonomy_upload}
\title{Upload a taxonomy file}
\usage{
opal.taxonomy_upload(opal, path)
}
\arguments{
\item{opal}{Opal object.}

\item{path}{Path to the taxonomy YAML file.}
}
\description{
Upload a taxonomy stored in a local file in YAML format. This operation 
will fail if the taxonomy already exists, see \link{opal.taxonomy_delete}.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.taxonomy_upload(o, '~/some/dir/taxo.yml')
opal.logout(o)
}
}
\seealso{
Other taxonomy functions: 
\code{\link{opal.taxonomies}()},
\code{\link{opal.taxonomy_delete}()},
\code{\link{opal.taxonomy_download}()},
\code{\link{opal.taxonomy}()},
\code{\link{opal.terms}()},
\code{\link{opal.vocabularies}()},
\code{\link{opal.vocabulary}()}
}
\concept{taxonomy functions}
