/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import opennlp.maxent.DataIndexer;
import opennlp.maxent.DataStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinder;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.Sequence;

public class NameFinderME
implements NameFinder {
    protected MaxentModel _npModel;
    protected NameContextGenerator _contextGen;
    private Sequence bestSequence;
    private BeamSearch beam;
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";

    public NameFinderME(MaxentModel mod) {
        this(mod, new DefaultNameContextGenerator(10), 10);
    }

    public NameFinderME(MaxentModel mod, NameContextGenerator cg) {
        this(mod, cg, 10);
    }

    public NameFinderME(MaxentModel mod, NameContextGenerator cg, int beamSize) {
        this._npModel = mod;
        this._contextGen = cg;
        this.beam = new NameBeamSearch(beamSize, cg, mod, beamSize);
    }

    public List find(List toks, Map prevTags) {
        this.bestSequence = this.beam.bestSequence(toks, new Object[]{prevTags});
        return this.bestSequence.getOutcomes();
    }

    public String[] find(Object[] toks, Map prevTags) {
        this.bestSequence = this.beam.bestSequence(toks, new Object[]{prevTags});
        List c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    protected boolean validOutcome(String outcome, Sequence sequence) {
        if (outcome.equals(CONTINUE)) {
            List tags = sequence.getOutcomes();
            int li = tags.size() - 1;
            if (li == -1) {
                return false;
            }
            if (((String)tags.get(li)).equals(OTHER)) {
                return false;
            }
        }
        return true;
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    private static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((int)iterations, (DataIndexer)new TwoPassDataIndexer(es, cut));
    }

    public static void usage() {
        System.err.println("Usage: opennlp.tools.namefind.NameFinderME -encoding encoding training_file model");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            NameFinderME.usage();
        }
        try {
            int ai = 0;
            String encoding = null;
            while (args[ai].startsWith("-")) {
                if (!args[ai].equals("-encoding")) continue;
                if (++ai < args.length) {
                    encoding = args[ai];
                    ++ai;
                    continue;
                }
                NameFinderME.usage();
            }
            File inFile = new File(args[ai++]);
            File outFile = new File(args[ai++]);
            NameFinderEventStream es = new NameFinderEventStream((DataStream)new PlainTextByLineDataStream((Reader)new InputStreamReader((InputStream)new FileInputStream(inFile), encoding)));
            GISModel mod = args.length > ai ? NameFinderME.train(es, Integer.parseInt(args[ai++]), Integer.parseInt(args[ai++])) : NameFinderME.train(es, 100, 5);
            System.out.println("Saving the model as: " + outFile);
            new SuffixSensitiveGISModelWriter(mod, outFile).persist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class NameBeamSearch
    extends BeamSearch {
        public NameBeamSearch(int size, NameContextGenerator cg, MaxentModel model, int beamSize) {
            super(size, cg, model, beamSize);
        }

        protected boolean validSequence(int i, List sequence, Sequence s, String outcome) {
            return NameFinderME.this.validOutcome(outcome, s);
        }
    }
}

