/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;

public final class RegexNameFinder
implements TokenNameFinder {
    private final Pattern[] mPatterns;

    public RegexNameFinder(Pattern[] patterns) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or emtpy!");
        }
        this.mPatterns = patterns;
    }

    public Span[] find(String[] tokens) {
        HashMap<Integer, Integer> sentencePosTokenMap = new HashMap<Integer, Integer>();
        StringBuffer sentenceString = new StringBuffer(tokens.length * 10);
        for (int i = 0; i < tokens.length; ++i) {
            int startIndex = sentenceString.length();
            sentencePosTokenMap.put(new Integer(startIndex), new Integer(i));
            sentenceString.append(tokens[i]);
            int endIndex = sentenceString.length();
            sentencePosTokenMap.put(new Integer(endIndex), new Integer(i));
            if (i >= tokens.length - 1) continue;
            sentenceString.append(' ');
        }
        LinkedList<Span> annotations = new LinkedList<Span>();
        for (int i = 0; i < this.mPatterns.length; ++i) {
            Matcher matcher = this.mPatterns[i].matcher(sentenceString);
            while (matcher.find()) {
                Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(new Integer(matcher.start()));
                Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(new Integer(matcher.end()));
                if (tokenStartIndex == null || tokenEndIndex == null) continue;
                Span annotation = new Span(tokenStartIndex, tokenEndIndex);
                annotations.add(annotation);
            }
        }
        return annotations.toArray(new Span[annotations.size()]);
    }
}

