% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zDeprecated.R
\name{polarMapStatic}
\alias{polarMapStatic}
\alias{diffMapStatic}
\alias{annulusMapStatic}
\alias{windroseMapStatic}
\alias{pollroseMapStatic}
\alias{percentileMapStatic}
\alias{freqMapStatic}
\title{Deprecated static directional analysis functions}
\usage{
polarMapStatic(
  data,
  pollutant = NULL,
  x = "ws",
  limits = "free",
  upper = "fixed",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  facet = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

diffMapStatic(
  before,
  after,
  pollutant = NULL,
  limits = "free",
  x = "ws",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  facet = NULL,
  cols = c("#002F70", "#3167BB", "#879FDB", "#C8D2F1", "#F6F6F6", "#F4C8C8", "#DA8A8B",
    "#AE4647", "#5F1415"),
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

annulusMapStatic(
  data,
  pollutant = NULL,
  period = "hour",
  facet = NULL,
  limits = "free",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

windroseMapStatic(
  data,
  ws.int = 2,
  breaks = 4,
  facet = NULL,
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

pollroseMapStatic(
  data,
  pollutant = NULL,
  statistic = "prop.count",
  breaks = NULL,
  facet = NULL,
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

percentileMapStatic(
  data,
  pollutant = NULL,
  percentile = c(25, 50, 75, 90, 95),
  intervals = "fixed",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  facet = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)

freqMapStatic(
  data,
  pollutant = NULL,
  statistic = "mean",
  breaks = "free",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  provider = "osm",
  facet = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)
}
\arguments{
\item{data}{\emph{Input data table with pollutant, wind, and geo-spatial
information.}

\strong{required} | \emph{scope:} dynamic & static

A data frame. The data frame must contain the data to plot the directional
analysis marker, which includes wind speed (\code{ws}), wind direction (\code{wd}),
and the column representing the concentration of a pollutant. In addition,
\code{data} must include a decimal latitude and longitude (or X/Y coordinate
used in conjunction with \code{crs}).}

\item{pollutant}{\emph{Pollutant name(s).}

\strong{required} | \emph{scope:} dynamic & static

The column name(s) of the pollutant(s) to plot. If multiple pollutants are
specified the \code{type} argument will no longer be able to be used, and:
\itemize{
\item \emph{Dynamic}: The pollutants can be toggled between using a "layer control" menu.
\item \emph{Static:}: The pollutants will each appear in a different panel.
}

Multiple \code{pollutants} prohibit the use of the \code{type} argument.}

\item{x}{\emph{The radial axis variable.}

\emph{default:} \code{"ws"} | \emph{scope:} dynamic & static

The column name for the radial axis variable to use in
\code{\link[openair:polarPlot]{openair::polarPlot()}}. Defaults to using wind speed, \code{"ws"}, but other
meteorological variables such as ambient temperature or atmospheric
stability may be useful.}

\item{limits}{\emph{Specifier for the plot colour scale bounds.}

\emph{default:} \code{"free"} | \emph{scope:} dynamic & static

One of:
\itemize{
\item \code{"fixed"} which ensures all of the markers use the same colour scale.
\item \code{"free"} (the default) which allows all of the markers to use different
colour scales.
\item A numeric vector in the form \code{c(lower, upper)} used to define the colour
scale. For example, \code{limits = c(0, 100)} would force the plot limits to
span 0-100.
}}

\item{upper}{\emph{Specifier for the polar plot radial axis upper boundary.}

\emph{default:} \code{"fixed"} | \emph{scope:} dynamic & static

One of:
\itemize{
\item \code{"fixed"} (the default) which ensures all of the markers use the same radial axis scale.
\item \code{"free"} which allows all of the markers to use different radial axis scales.
\item A numeric value, used as the upper limit for the radial axis scale.
}}

\item{latitude, longitude}{\emph{The decimal latitude(Y)/longitude(X).}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Column names representing the decimal latitude and longitude (or other Y/X
coordinate if using a different \code{crs}). If not provided, will be
automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{crs}{\emph{The coordinate reference system (CRS).}

\emph{default:} \code{4326} | \emph{scope:} dynamic & static

The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for
plotting on the map.}

\item{provider}{\emph{The basemap(s) to be used.}

\emph{default:} \code{"OpenStreetMap"} | \emph{scope:} dynamic & static

The base map(s) to be used beneath the polar markers. If not provided, will
default to \code{"OpenStreetMap"}/\code{"osm"} for both dynamic and static maps.
\itemize{
\item \emph{Dynamic}: Any number of \link[leaflet:providers]{leaflet::providers}.
See \url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface. By default, the
interface will use the provider names as labels, but users can define their
own using a named vector (e.g., \code{c("Default" = "OpenStreetMap", "Satellite"   = "Esri.WorldImagery")})
\item \emph{Static}: One of \code{\link[rosm:deprecated]{rosm::osm.types()}}.
}

There is some overlap in static and dynamic providers. For example,
\code{{ggspatial}} uses "osm" to specify "OpenStreetMap". When static providers
are provided to dynamic maps or vice versa, \code{{openairmaps}} will attempt to
substitute the correct provider string.}

\item{facet}{Passed to the \code{type} argument of the relevant \code{polarMap()}
family function.}

\item{cols}{\emph{Colours to use for plotting.}

\emph{default:} \code{"turbo"} | \emph{scope:} dynamic & static

The colours used for plotting, passed to \code{\link[openair:openColours]{openair::openColours()}}. The
default, \code{"turbo"}, is a rainbow palette with relatively perceptually
uniform colours. Read more about this palette at
\url{https://research.google/blog/turbo-an-improved-rainbow-colormap-for-visualization/}.}

\item{alpha}{\emph{Transparency value for polar markers.}

\emph{default:} \code{1} | \emph{scope:} dynamic & static

A value between 0 (fully transparent) and 1 (fully opaque).}

\item{key}{\emph{Draw individual marker legends?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic & static

Draw a key for each individual marker? Potentially useful when \code{limits = "free"}, but of limited use otherwise.}

\item{facet.nrow}{Passed to the \code{static.nrow} argument of the relevant
\code{polarMap()} family function.}

\item{d.icon}{\emph{The diameter of the plot on the map in pixels.}

\emph{default:} \code{200} | \emph{scope:} dynamic & static

This will affect the size of the individual polar markers. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{d.fig}{\emph{The diameter of the plots to be produced using \code{{openair}} in
inches.}

\emph{default:} \code{3.5} | \emph{scope:} dynamic & static

This will affect the resolution of the markers on the map. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{...}{Passed to the polar plotting function}

\item{before}{A data frame that represents the "before" case. See
\code{\link[openair:polarPlot]{polarPlot()}} for details of different input requirements.}

\item{after}{A data frame that represents the "after" case. See \code{\link[openair:polarPlot]{polarPlot()}}
for details of different input requirements.}

\item{period}{\emph{Temporal period for radial axis.}

\emph{default:} \code{"hour"} | \emph{scope:} dynamic & static

Options are "hour" (the default, to plot diurnal variations), "season" to
plot variation throughout the year, "weekday" to plot day of the week
variation and "trend" to plot the trend by wind direction.}

\item{ws.int}{\emph{The wind speed interval of the colour axis.}

\emph{default:} \code{2} | \emph{scope:} dynamic & static

The wind speed interval. Default is 2 m/s but for low met masts with low
mean wind speeds a value of 1 or 0.5 m/s may be better.}

\item{breaks}{\emph{Specifier for the number of breaks of the colour axis.}

\emph{default:} \code{4} | \emph{scope:} dynamic & static

Most commonly, the number of break points for wind speed in
\code{\link[openair:windRose]{openair::windRose()}}. For the \code{ws.int} default of \code{2}, the default
\code{breaks}, \code{4}, generates the break points 2, 4, 6, and 8. Breaks can also
be used to set specific break points. For example, the argument `breaks =
c(0, 1, 10, 100)`` breaks the data into segments <1, 1-10, 10-100, >100.}

\item{statistic}{\emph{The statistic to be applied to each data bin in the plot}

\emph{default:} \code{"prop.mean"} | \emph{scope:} dynamic & static

Options currently include \code{"prop.count"}, \code{"prop.mean"} and \code{"abs.count"}.
\code{"prop.count"} sizes bins according to the proportion of the frequency of
measurements.  Similarly, \code{"prop.mean"} sizes bins according to their
relative contribution to the mean. \code{"abs.count"} provides the absolute
count of measurements in each bin.}

\item{percentile}{\emph{The percentile values for the colour scale bin.}

\emph{default:} \code{c(25, 50, 75, 90, 95)} | \emph{scope:} dynamic & static

The percentile value(s) to plot using \code{\link[openair:percentileRose]{openair::percentileRose()}}. Must be
a vector of values between \code{0} and \code{100}. If \code{percentile = NA} then only a
mean line will be shown.}

\item{intervals}{\emph{Specifier for the percentile rose radial axis intervals.}

\emph{default:} \code{"fixed"} | \emph{scope:} dynamic & static

One of:
\itemize{
\item \code{"fixed"} (the default) which ensures all of the markers use the same radial axis scale.
\item \code{"free"} which allows all of the markers to use different radial axis scales.
\item A numeric vector defining a sequence of numbers to use as the intervals, e.g., \code{intervals = c(0, 10, 30, 50)}.
}}
}
\value{
a \code{ggplot2} object using \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} coordinates with a
\code{ggspatial} basemap
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Static direction analysis mapping functions have been deprecated in favour
of combined functions (e.g., \code{polarMap()}), which present a more
consistent, unified API for users to simply swap between the two output
formats.
}
\seealso{
\code{\link[=polarMap]{polarMap()}}
}
\concept{deprecated functions}
