% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{quickTextHTML}
\alias{quickTextHTML}
\title{Automatic text formatting for \code{openairmaps}}
\usage{
quickTextHTML(text)
}
\arguments{
\item{text}{\emph{A character vector.}

\strong{required}

A character vector containing common pollutant names to be formatted.
Commonly, this will insert super- and subscript HTML tags, e.g., "NO2" will
be replaced with "NO\if{html}{\out{<sub>}}2\if{html}{\out{</sub>}}".}
}
\value{
a character vector
}
\description{
Workhorse function that automatically applies routine text formatting to
common pollutant names which may be used in the HTML widgets produced by
\code{openairmaps}.
}
\details{
\code{\link[=quickTextHTML]{quickTextHTML()}} is routine formatting lookup table. It screens the supplied
character vector \code{text} and automatically applies formatting to any
recognised character sub-series to properly render in HTML.
}
\examples{
labs <- c("no2", "o3", "so2")
quickTextHTML(labs)

}
\seealso{
\code{\link[openair:quickText]{openair::quickText()}}, useful for non-HTML/static maps and plots
}
\author{
Jack Davison.
}
