% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audio.R
\name{audio}
\alias{audio}
\title{audio Class}
\description{
To turn audio into text or text into audio
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{audio}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-audio-speech}{\code{audio$speech()}}
\item \href{#method-audio-transcription}{\code{audio$transcription()}}
\item \href{#method-audio-translation}{\code{audio$translation()}}
\item \href{#method-audio-clone}{\code{audio$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-audio-speech"></a>}}
\if{latex}{\out{\hypertarget{method-audio-speech}{}}}
\subsection{Method \code{speech()}}{
Generates audio from the input text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{audio$speech(
  model = "tts-1",
  input,
  voice = "alloy",
  stream = F,
  num = 100,
  ...,
  verbosity = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character Required. One of the available TTS models: tts-1 or tts-1-hd}

\item{\code{input}}{character Required. The text to generate audio for. The maximum length is 4096 characters.}

\item{\code{voice}}{character Required. The voice to use when generating the audio. Supported voices are alloy, echo, fable, onyx, nova, and shimmer.}

\item{\code{stream}}{logical. Using the stream call, it will return raw data of the specified length,
which can be saved in the set format such as mp3, etc. For details, please see the examples.}

\item{\code{num}}{The num parameter controls the number of raw entries returned by a stream in one go.
Note that this is different from the n parameter, which specifies the number of results returned.
For detailed information on the n parameter, please refer to OpenAI's API documentation.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:response_format;speed....}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The audio file content.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-audio-transcription"></a>}}
\if{latex}{\out{\hypertarget{method-audio-transcription}{}}}
\subsection{Method \code{transcription()}}{
Transcribes audio into the input language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{audio$transcription(path, model = "whisper-1", ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{character Required. The audio file object (not file name) to transcribe,
in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{\code{model}}{character Required. ID of the model to use. Only whisper-1 is currently available.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:language;prompt;response_format;temperature....}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transcribed text.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-audio-translation"></a>}}
\if{latex}{\out{\hypertarget{method-audio-translation}{}}}
\subsection{Method \code{translation()}}{
Translates audio into English.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{audio$translation(path, model = "whisper-1", ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{character Required. The audio file object (not file name) to transcribe,
in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.}

\item{\code{model}}{character Required. ID of the model to use. Only whisper-1 is currently available.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:prompt;response_format;temperature....}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The transcribed text.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-audio-clone"></a>}}
\if{latex}{\out{\hypertarget{method-audio-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{audio$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
