% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{control_keys}
\alias{control_keys}
\alias{control}
\alias{control<-}
\title{Get or set OpenMPT module controls}
\usage{
control_keys(mod, ...)

control(mod, key, ...)

control(mod, key, ...) <- value
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}

\item{key}{A \code{character} string representing a specific control you whish to get or set.
Use \code{control_keys()} to list all available keys.}

\item{value}{A replacement value for the specified control \code{key}. Check the
libopenmpt \href{https://buildbot.openmpt.org/builds/latest-unpacked/libopenmpt-docs/docs/classopenmpt_1_1module.html#a4870472969da4d659c5cc394bb1ed245}{documentation}
for the appropriate replacement types and values for each of the \code{key} values.}
}
\value{
\code{control_keys()} returns a \code{vector} of strings containing all available
control keys for \code{mod}. \code{control()} returns the value for the specified \verb{key'. In case of an assign operator (}<-\verb{) an updated version of }mod` is
returned, where the control key has been set if successful.
}
\description{
Each individual module has its own set of control parameters. Use these functions
to obtain or set the state of these parameters.
}
\examples{
mod <- demo_mod()
control_keys(mod)

## get a specific control value
control(mod, "play.at_end")

## set a number of control values
control(mod, "play.at_end") <- "stop"
control(mod, "play.pitch_factor") <- 2
control(mod, "load.skip_plugins") <- TRUE
control(mod, "dither") <- 2L

## Show all control settings
all_keys <- control_keys(mod)
structure(
  lapply(all_keys, control, mod = mod),
  names = all_keys
)
}
