\name{maxCaliper}
\alias{maxCaliper}
\title{Find the maximum caliper width that will create a feasible problem.}
\usage{
  maxCaliper(scores, z, widths, structure = NULL,
    exact = TRUE)
}
\arguments{
  \item{scores}{A numeric vector of scores providing 1-D
  position of units}

  \item{z}{Treatment indicator vector}

  \item{widths}{A vector of caliper widths to try, will be
  sorted largest to smallest.}

  \item{structure}{Optional factor variable that groups the
  scores, as would be used by \code{\link{exactMatch}}.
  Including structure allows for wider calipers.}

  \item{exact}{A logical indicating if the exact problem
  size should be computed (\code{exact = TRUE}) or if a
  more computationally efficient upper bound should be used
  instead (\code{exact = FALSE}). The upper bound may lead
  to narrower calipers, even if wider calipers would have
  sufficed using the exact method.}
}
\value{
  numeric The value of the largest caliper that creates a
  feasible problem. If no such caliper exists in
  \code{widths}, an error will be generated.
}
\description{
  Larger calipers permit more possible matches between
  treated and control groups, which can be better for
  creating matches with larger effective sample sizes. The
  downside is that wide calipers may make the matching
  problem too big for processor or memory constraints.
  \code{maxCaliper} attempts to find a caliper value, for a
  given vector of scores and a treatment indicator, that
  will be possible given the maximum problem size
  constraints imposed by \code{\link{fullmatch}} and
  \code{\link{pairmatch}}.
}

