% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{orderly_init}
\alias{orderly_init}
\title{Initialise an orderly store}
\usage{
orderly_init(root, doc = TRUE, quiet = FALSE)
}
\arguments{
\item{root}{The root of the store; this must be an empty directory
or the path of a directory to create}

\item{doc}{Logical, indicating if documentation should be added to
the directories.  This also has the (potentially useful) effect
of making these directories noticeable by git.}

\item{quiet}{Logical, indicating if informational messages should
be suppressed.}
}
\value{
The path to the newly created archive
}
\description{
Initialise an orderly store.  This is a helper function that
automates getting started with using orderly for a new project.
It is not required to use - you can create the orderly structure
yourself (all that is compulsory is the \code{orderly_config.yml}
file).
}
\details{
This function creates a minimal orderly structure, containing:
\describe{

\item{\code{orderly_config.yml}}{The orderly
configuration. Minimally, this can be empty, but it must exist.}

\item{\code{src}}{The path where report sources live. This should
be placed under version control, and contain a number of reports,
each in their own directory with an \code{orderly.yml} describing
their inputs and outputs (artefacts).  The
\code{\link{orderly_new}} function can be used to accelerate
creation of new reports.}

\item{\code{draft}}{A directory where reports will be run using
\code{\link{orderly_run}}.  This directory should be excluded from
version control. \code{orderly} will create it as needed if it
does not exist when a report is run.}

\item{\code{archive}}{A directory where successfully run reports
will be moved to after being committed with
\code{\link{orderly_commit}}.  This directory should be excluded
from version control. \code{orderly} will create it as needed if
it does not exist when a report is committed.}

\item{\code{data}}{A directory where data extracted from the
database (if used) will be stored.  This directory should be
excluded from version control. \code{orderly} will create it as
needed if it does not exist when a report is run.}

}
}
\examples{
# Initialise a new orderly repository in an temporary directory:
path <- orderly::orderly_init(tempfile())

# This has created the directory skeleton that you need to get
# started using orderly:
fs::dir_tree(path)

# As instructed, the next thing to do is to edit the
# orderly_config.yml file to match your needs:
readLines(file.path(path, "orderly_config.yml"))
}
\seealso{
\code{\link{orderly_new}} for creating new reports within
  a configured orderly repository.
}
