% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun-lra.r
\name{lra-ord}
\alias{lra-ord}
\alias{lra}
\alias{print.lra}
\alias{screeplot.lra}
\alias{biplot.lra}
\alias{plot.lra}
\title{Log-ratio analysis}
\usage{
lra(x, compositional = FALSE, weighted = TRUE)

\method{print}{lra}(x, nd = length(x$sv), n = 6L, ...)

\method{screeplot}{lra}(x, main = deparse1(substitute(x)), ...)

\method{biplot}{lra}(
  x,
  choices = c(1L, 2L),
  scale = c(0, 0),
  main = deparse1(substitute(x)),
  var.axes = FALSE,
  ...
)

\method{plot}{lra}(x, main = deparse1(substitute(x)), ...)
}
\arguments{
\item{x}{A numeric matrix or rectangular data set.}

\item{compositional}{Logical; whether to normalize rows of \code{x} to sum to 1.}

\item{weighted}{Logical; whether to weight rows and columns by their sums.}

\item{nd}{Integer; number of shared dimensions to include in print.}

\item{n}{Integer; number of rows of each factor to print.}

\item{main, var.axes, ...}{Parameters passed to other plotting methods (in the
case of \code{main}, after being \code{\link[=force]{force()}}d.}

\item{choices}{Integer; length-2 vector specifying the components to plot.}

\item{scale}{Numeric; values between 0 and 1 that control how inertia is
conferred unto the points: Row (\code{i = 1L}) and column (\code{i = 2L}) coordinates
are scaled by \code{sv ^ scale[[i]]}. If a single value \code{scale} is passed, it is
assigned to the rows while \code{1 - scale} is assigned to the columns.}
}
\value{
Given an \eqn{n * p} data matrix and setting \eqn{r=min(n,p)},
\code{lra()} returns a list of class \code{"lra"} containing three elements:
\itemize{
\item{sv}{The \eqn{r-1} singular values}
\item{row.coords}{The \eqn{n * (r-1)} matrix
of row standard coordinates.}
\item{column.coords}{The \eqn{p * (r-1)} matrix
of column standard coordinates.}
\item{row.weights}{The weights used to scale the row coordinates.}
\item{column.weights}{The weights used to scale the column coordinates.}
}
}
\description{
Represent log-ratios between variables based on their values on
a population of cases.
}
\details{
Log-ratio analysis (LRA) is based on a double-centering of log-transformed
data, usually weighted by row and column totals. The technique is suitable
for positive-valued variables on a common scale (e.g. percentages). The
distances between variables' coordinates (in the full-dimensional space) are
their pairwise log-ratios. The distances between cases' coordinates are
called their \emph{log-ratio distances}, and the total variance is the weighted
sum of their squares.

LRA is not implemented in standard R distributions but is a useful member of
the ordination toolkit. This is a minimal implementation following
Greenacre's (2010) exposition in Chapter 7.
}
\examples{
# U.S. 1973 violent crime arrests
head(USArrests)
# row and column subsets
state_examples <- c("Hawaii", "Mississippi", "North Dakota")
arrests <- c(1L, 2L, 4L)

# pairwise log-ratios of violent crime arrests for two states
arrest_pairs <- combn(arrests, 2L)
arrest_ratios <-
  USArrests[, arrest_pairs[1L, ]] / USArrests[, arrest_pairs[2L, ]]
colnames(arrest_ratios) <- paste(
  colnames(USArrests)[arrest_pairs[1L, ]], "/",
  colnames(USArrests)[arrest_pairs[2L, ]], sep = ""
)
arrest_logratios <- log(arrest_ratios)
arrest_logratios[state_examples, ]

# non-compositional log-ratio analysis
(arrests_lra <- lra(USArrests[, arrests]))
screeplot(arrests_lra)
biplot(arrests_lra, scale = c(1, 0))

# compositional log-ratio analysis
(arrests_lra <- lra(USArrests[, arrests], compositional = TRUE))
biplot(arrests_lra, scale = c(1, 0))
}
\references{
Greenacre MJ (2010) \emph{Biplots in Practice}. Fundacion BBVA, ISBN:
978-84-923846.
\url{https://www.fbbva.es/microsite/multivariate-statistics/biplots.html}
}
