% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{check_damaging}
\alias{check_damaging}
\title{Check Damaging Probability}
\usage{
check_damaging(project, edits, ...)
}
\arguments{
\item{project}{a Wikimedia project. Supported projects can be obtained with
\code{\link{list_wikis}}. If NULL (the default), model information will be
retrieved for all projects.}

\item{edits}{a revision ID, or vector of revision IDs, of the edits
to check.}

\item{...}{further arguments to pass to httr's GET.}
}
\value{
A data.frame of five columns; \code{edit}, the
edit ID, \code{project}, the project, \code{prediction},
whether the model predicts that the edit was damaging,
\code{false_prob}, the probability that the model's prediction
is wrong, and \code{true_prob}, the probability that the model's
prediction is correct. In the event of an error (due to the edit
not being available) NAs will be returned in that row.
}
\description{
\code{check_damaging} identifies whether
or not an edit was damaging - the type that caused actual
harm to an article.
}
\examples{
# A simple, single-diff example
damaging_data <- check_damaging("enwiki", 34854345)

}
\seealso{
\code{\link{check_goodfaith}} to identify if a set of edits were made
in good faith, and \code{\link{check_quality}} to see a prediction of
the article quality class.
}
