% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ormForestplot.R
\name{plot.summary.rms}
\alias{plot.summary.rms}
\alias{forestplot}
\alias{forestplot.orm}
\alias{forestplot.lrm}
\alias{forestplot.default}
\alias{forestplot.summary.rms}
\title{Forest Plot of an rms model summary}
\usage{
\method{plot}{summary.rms}(x, ...)

forestplot(x, return_ggplots = FALSE, plot.widths = c(0.5, 0.5),
  title = "Odds ratio", digits = 3, shape = 19, header = NULL,
  limits = NULL, breaks = c(0.5, 1, 1.5, 2, 3, 4),
  theme = ggplot2::theme_get(), row.names.y = NULL)

forestplot.default(x, ...)

forestplot.summary.rms(x, ...)
}
\arguments{
\item{x}{result of a \code{summary} command on
\code{\link[rms]{orm}} or \code{\link[rms]{lrm}}  model ie a
\code{\link[rms]{summary.rms}} class object}

\item{...}{see parameters of method \code{\link{forestplot}}}

\item{return_ggplots}{if \code{TRUE} the function returns 2 ggplot objects
in a list instead of drawing a tablegrid}

\item{plot.widths}{the relative widths of the left and right plot
should be a vector (\code{c()})  with 2 elements that sum to 1 defaults to
equal widths}

\item{title}{the tile row of the drawn plot}

\item{digits}{the number of significant digits to display}

\item{shape}{point shape, see \code{\link[ggplot2]{aes_linetype_size_shape}}}

\item{header}{names of the table columns}

\item{limits}{the x axis limits as a vector, see also:
\code{\link[ggplot2]{scale_continuous}}}

\item{breaks}{the x axis breaks as a vector,help see also:
\code{\link[ggplot2]{scale_continuous}}}

\item{theme}{the desired ggplot2 theme}

\item{row.names.y}{new names for the variable rows}
}
\description{
Convenience function to create a plot of the \code{\link[rms]{orm}}  model
summary. For further customizing the plots use \code{return_ggplots = TRUE}
This will create 2 \code{ggplot2} objects that can be joined with the
\code{\link{join_ggplots}} commands.
}
\examples{
set.seed(123)
#load the libraries
library(rms)
library(ormPlot)

#make the datadist
dd<-rms::datadist(educ_data)
options(datadist="dd")

#create the model
cran_model <- orm(educ_3 ~ YOBc + sex + height_rzs + n_siblings  + cran_rzs, data = educ_data)

#the antilog true produces odd ratios (default value for orm and lrm)
s<-summary(cran_model, antilog = TRUE)

#set the plotting default theme (optional)
theme_set(theme_classic())

#show simply the result
forestplot(s)

#return modifiable ggplots
forestplot(s, return_ggplots = TRUE )

#new row names and header
newnames <- c("Year of birth", "Height", "Number of children", "Cranial volume", "Sex" )
newhead <- c("Odds Ratio", "CI 5\%", "CI 95\%" )

#adjust also the relative plot widths and change the color and shape
newtheme <- theme_classic() + theme(text = element_text(color = "red", size = 12),
                                    line = element_line(color= "red"),
                                    rect = element_rect(color="red"))

forestplot(s, row.names.y = newnames, header = newhead,
           plot.widths = c(0.6,0.4), shape = 17,
           theme = newtheme)
}
