% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convert_anlz.R
\name{Convert ANALYZE Codes}
\alias{Convert ANALYZE Codes}
\alias{convert.bitpix.anlz}
\alias{convert.datatype.anlz}
\alias{convert.orient.anlz}
\title{Convert ANALYZE Codes}
\usage{
convert.bitpix.anlz(bitpix = NULL)

convert.datatype.anlz(datatype.code = NULL)

convert.orient.anlz(orientation)
}
\arguments{
\item{bitpix}{is the bit-per-pixel code.}

\item{datatype.code}{defines data type.}

\item{orientation}{defines the orientation.}
}
\value{
A character string.
}
\description{
Codes that appear in the ANALYZE header are mapped to
meaningful chartacter strings.
}
\details{
\code{switch} statements are used to map a numeric code to the
appropriate string.
}
\examples{
##  4 = SIGNED_SHORT
convert.datatype.anlz(4)
## 16 = FLOAT
convert.datatype.anlz(16)
##  2 = "saggital unflipped"
convert.orient.anlz(2)
##  4 = "coronal flipped"
convert.orient.anlz(4)
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
ANALYZE 7.5\cr\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}
}
\seealso{
\code{\link{convert.datatype}}, \code{\link{convert.bitpix}},
\code{\link{convert.intent}}, \code{\link{convert.form}},
\code{\link{convert.units}}, \code{\link{convert.slice}}
}

